/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.xml.core.parsing.ast;

import beaver.Symbol;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.parsing.ast.INameNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseNodeAttribute;
import com.aptana.parsing.ast.ParseNode;
import com.aptana.parsing.ast.ParseNodeAttribute;
import com.aptana.parsing.lexer.IRange;
import com.aptana.xml.core.parsing.XMLParser;
import com.aptana.xml.core.parsing.ast.XMLNode;
import com.aptana.xml.core.parsing.ast.XMLNodeType;
import java.util.LinkedHashMap;
import java.util.Map;

public class XMLElementNode
extends XMLNode {
    private ParseNode.NameNode fNameNode;
    private final boolean fIsSelfClosing;
    private Map<String, IParseNodeAttribute> fAttributes;
    private int startClose;

    public XMLElementNode(Symbol tag, int start, Symbol close) {
        super(XMLNodeType.ELEMENT, XMLParser.NO_XML_NODES, start, close.getEnd());
        this.fNameNode = new ParseNode.NameNode((String)tag.value, tag.getStart(), tag.getEnd());
        this.fIsSelfClosing = close.getId() == 8;
        this.startClose = close.getEnd();
    }

    public int getStartTagEndOffset() {
        return this.startClose;
    }

    public void addOffset(int offset) {
        IRange range = this.fNameNode.getNameRange();
        this.fNameNode = new ParseNode.NameNode(this.fNameNode.getName(), range.getStartingOffset() + offset, range.getEndingOffset() + offset);
        this.startClose += offset;
        super.addOffset(offset);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof XMLElementNode)) {
            return false;
        }
        return ObjectUtil.areEqual((Object)this.getName(), (Object)((XMLElementNode)((Object)obj)).getName());
    }

    public String getAttributeValue(String name) {
        if (this.fAttributes == null) {
            return null;
        }
        IParseNodeAttribute attr = this.fAttributes.get(name);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public IParseNodeAttribute[] getAttributes() {
        if (this.fAttributes == null) {
            return ParseNode.NO_ATTRIBUTES;
        }
        return this.fAttributes.values().toArray(new IParseNodeAttribute[this.fAttributes.size()]);
    }

    public IParseNodeAttribute getAttributeAtOffset(int offset) {
        Object[] attrs = this.getAttributes();
        if (ArrayUtil.isEmpty((Object[])attrs)) {
            return null;
        }
        Object[] objectArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Object attr = objectArray[n2];
            IRange nameRange = attr.getNameRange();
            if (nameRange != null && nameRange.contains(offset)) {
                return attr;
            }
            IRange valueRange = attr.getValueRange();
            if (valueRange != null && valueRange.contains(offset)) {
                return attr;
            }
            ++n2;
        }
        return null;
    }

    public String getName() {
        return this.fNameNode.getName();
    }

    public INameNode getNameNode() {
        return this.fNameNode;
    }

    public String getText() {
        return this.fNameNode.getName();
    }

    public int hashCode() {
        String name = this.getName();
        return 31 * super.hashCode() + (name == null ? 1 : this.getName().hashCode());
    }

    public boolean isSelfClosing() {
        return this.fIsSelfClosing;
    }

    public void setAttribute(String name, String value, IRange nameRange, IRange valueRange) {
        if (this.fAttributes == null) {
            this.fAttributes = new LinkedHashMap<String, IParseNodeAttribute>(2);
        }
        this.fAttributes.put(name, (IParseNodeAttribute)new ParseNodeAttribute((IParseNode)this, name, StringUtil.stripQuotes((String)value), nameRange, valueRange));
    }

    public String toString() {
        IParseNode[] children;
        String name = this.getName();
        if (StringUtil.isEmpty((String)name)) {
            return "";
        }
        StringBuilder text = new StringBuilder();
        text.append('<').append(name).append('>');
        IParseNode[] iParseNodeArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode child = iParseNodeArray[n2];
            text.append(child);
            ++n2;
        }
        text.append("</").append(name).append('>');
        return text.toString();
    }
}

